
/*  -*- pse-c -*-
 *----------------------------------------------------------------------------
 * Filename: iegd_interface.c
 * $Revision: 1.1 $
 *----------------------------------------------------------------------------
 * Copyright 2003  2005 Intel Corporation. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *	Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *
 *      Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *
 *      Neither the name Intel Corporation nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *----------------------------------------------------------------------------
 * Functions:
 * 
 * 
 *----------------------------------------------------------------------------
 */

#include "iegd.h"
#include "drmP.h"
#include "drm.h"

#include "iegd_drm.h"
#include "iegd_drv.h"

#if KERNEL265 
#include "drm_agpsupport.h"
#include "drm_auth.h"
#include "drm_bufs.h"
#include "drm_context.h"
#include "drm_dma.h"
#include "drm_drawable.h"
#include "drm_drv.h"

#include "drm_fops.h"
#include "drm_init.h"
#include "drm_ioctl.h"
#include "drm_lock.h"
#include "drm_memory.h"
#include "drm_proc.h"
#include "drm_vm.h"
#include "drm_stub.h"

int intel_postinit_265(drm_device_t *dev){

	intel_device_private_t *priv;
	priv=(intel_device_private_t *)dev->dev_private;

	intel_postinit(&priv);
	dev->dev_private=priv;

	return 0;

}

int intel_prerelease_265(drm_device_t *dev){

	intel_prerelease(dev);

	return 0;

}

int intel_getpages_265( struct inode *inode, struct file *filp,
			  unsigned int cmd, unsigned long arg ){

	drm_file_t *priv=filp->private_data;
	drm_device_t *dev=priv->dev;
	return	intel_getpages(dev,filp,arg);


}

int intel_freepages_265( struct inode *inode, struct file *filp,
			  unsigned int cmd, unsigned long arg ){

	drm_file_t *priv=filp->private_data;
	drm_device_t *dev=priv->dev;
	return	intel_freepages(dev,arg);

}

int intel_drm_info_init_265( struct inode *inode, struct file *filp,
			  unsigned int cmd, unsigned long arg ){

	drm_file_t *priv=filp->private_data;
	drm_device_t *dev=priv->dev;
	return	intel_drm_info_init(dev,arg);

}

int intel_drm_info_get_265( struct inode *inode, struct file *filp,
			  unsigned int cmd, unsigned long arg ){

	drm_file_t *priv=filp->private_data;
	drm_device_t *dev=priv->dev;
	return	intel_drm_info_get(dev,arg);

}

struct file_operations intel_buffer_fops = {
	.open	 = DRM(open),
	.flush	 = DRM(flush),
	.release = DRM(release),
	.ioctl	 = DRM(ioctl),
	.mmap	 = intel_mmap_buffers,
	.fasync  = DRM(fasync),
};

#endif
/*end of 2.6.5 definition */


